#ifndef DS_CONTROL_DEVICE_SYNC_H
#define DS_CONTROL_DEVICE_SYNC_H

#include "global_types.h"
#include <stdbool.h>

/**
 * This component acts as the main controller of the program. It provides a member function
 * for inititialization, it implements the main loop, and provides a member function for
 * cleaning up before exiting.
 */

/**
 * Initilizes the complete program. Command line arguements are parsed.
 * In case of errors, one of the error codes defined in error_codes.h
 * is returned.
 * @param argc the number of command line arguments passed to the program
 * @param argv the command line arguments passed to the program
 * @return returns one of the error codes defined in error_codes.h or RESULT_OK
 * in case of no error.
 */
error_code_t device_sync_init(int argc,char *argv[]);

/**
 * Starts the main loop of the program. It does not return, until the program exits.
 * @return returns one of the error codes defined in error_codes.h or RESULT_OK
 * in case of no error.
 */
error_code_t device_sync_start(void);

/**
 * Cleans up the program. All memory allocated is released and all open files and sockets are closed.
 */
void device_sync_deinit(bool print_missing);

#endif
